/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.modifiers.dynamic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import slimeknights.mantle.data.GenericLoaderRegistry;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierLevelDisplay;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class ExtraModifier
extends Modifier {
    public static final GenericLoaderRegistry.IGenericLoader<ExtraModifier> LOADER = new GenericLoaderRegistry.IGenericLoader<ExtraModifier>(){

        public ExtraModifier deserialize(JsonObject json) {
            SlotType.SlotCount slots = SlotType.SlotCount.fromJson(GsonHelper.m_13930_((JsonObject)json, (String)"slots"));
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.getAndDeserialize(json, "level_display");
            boolean alwaysShow = GsonHelper.m_13855_((JsonObject)json, (String)"always_show", (boolean)false);
            return new ExtraModifier(slots.getType(), slots.getCount(), display, alwaysShow);
        }

        public void serialize(ExtraModifier object, JsonObject json) {
            JsonObject slots = new JsonObject();
            json.add("level_display", ModifierLevelDisplay.LOADER.serialize((GenericLoaderRegistry.IHaveLoader)object.levelDisplay));
            json.addProperty("always_show", Boolean.valueOf(object.alwaysShow));
            slots.addProperty(object.type.getName(), (Number)object.slotsPerLevel);
            json.add("slots", (JsonElement)slots);
        }

        public ExtraModifier fromNetwork(FriendlyByteBuf buffer) {
            SlotType type = SlotType.read(buffer);
            int slotCount = buffer.m_130242_();
            ModifierLevelDisplay display = (ModifierLevelDisplay)ModifierLevelDisplay.LOADER.fromNetwork(buffer);
            boolean alwaysShow = buffer.readBoolean();
            return new ExtraModifier(type, slotCount, display, alwaysShow);
        }

        public void toNetwork(ExtraModifier object, FriendlyByteBuf buffer) {
            object.type.write(buffer);
            buffer.m_130130_(object.slotsPerLevel);
            ModifierLevelDisplay.LOADER.toNetwork((GenericLoaderRegistry.IHaveLoader)object.levelDisplay, buffer);
            buffer.writeBoolean(object.alwaysShow);
        }
    };
    private final SlotType type;
    private final int slotsPerLevel;
    private final ModifierLevelDisplay levelDisplay;
    private final boolean alwaysShow;

    public static Builder builder(SlotType slotType) {
        return new Builder(slotType);
    }

    @Override
    public GenericLoaderRegistry.IGenericLoader<? extends Modifier> getLoader() {
        return LOADER;
    }

    @Override
    public boolean shouldDisplay(boolean advanced) {
        return this.alwaysShow || advanced;
    }

    @Override
    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        volatileData.addSlots(this.type, level * this.slotsPerLevel);
    }

    @Override
    public Component getDisplayName(int level) {
        return this.levelDisplay.nameForLevel(this, level);
    }

    @Override
    public int getPriority() {
        return this.alwaysShow ? 60 : 50;
    }

    protected ExtraModifier(SlotType type, int slotsPerLevel, ModifierLevelDisplay levelDisplay, boolean alwaysShow) {
        this.type = type;
        this.slotsPerLevel = slotsPerLevel;
        this.levelDisplay = levelDisplay;
        this.alwaysShow = alwaysShow;
    }

    public static class Builder {
        private final SlotType type;
        private boolean alwaysShow = false;
        private ModifierLevelDisplay display = ModifierLevelDisplay.SINGLE_LEVEL;
        private int slotsPerLevel = 1;

        public Builder alwaysShow() {
            this.alwaysShow = true;
            return this;
        }

        public ExtraModifier build() {
            return new ExtraModifier(this.type, this.slotsPerLevel, this.display, this.alwaysShow);
        }

        private Builder(SlotType type) {
            this.type = type;
        }

        public Builder display(ModifierLevelDisplay display) {
            this.display = display;
            return this;
        }

        public Builder slotsPerLevel(int slotsPerLevel) {
            this.slotsPerLevel = slotsPerLevel;
            return this;
        }
    }
}

